"use client"

import { useState, useEffect } from "react"

export type Language = "fr" | "en" | "ar" | "ru" | "es"

export const translations = {
  fr: {
    heroTitle: "Naïm.dev",
    heroStatus: "[DÉVELOPPEUR]",
    heroSubtitle:
      "Passionné par Linux, le Web et la Cybersécurité. Toujours en train d'apprendre et de créer de nouvelles choses.",
    heroTerminal1: "Fan inconditionnel de Linux. Windows ? Connais pas.",
    heroTerminal2: "Développeur Full Stack avec une préférence pour le Backend.",
    heroTerminal3: "Cybersecurity Enthusiast. La sécurité avant tout.",
    heroButton: "Voir mes projets",
    aboutTitle: "À propos de moi",
    aboutCardTitle: "Linux Evangelist",
    aboutText:
      "Développeur passionné par Linux, le Web et la Cybersécurité. Toujours en train d'apprendre et de créer de nouvelles choses. Je suis un grand fan de Linux et je pense que c'est le meilleur système d'exploitation au monde. Je suis également un développeur Full Stack avec une préférence pour le Backend. J'aime créer des APIs et des applications web robustes et performantes. Enfin, je suis un Cybersecurity Enthusiast. La sécurité est primordiale pour moi et je fais toujours de mon mieux pour protéger mes systèmes et mes données.",
    aboutLearning: "J'apprends actuellement le Reverse Engineering et l'Analyse de Malware.",
    aboutPivot: "Objectif : Devenir un Data Scientist de l'Extrême.",
    journeyTitle: "Mon parcours",
    journey2018: "Découverte du code avec HTML et CSS. Premiers pas dans le monde du développement web.",
    journey2020: "Python devient mon langage de prédilection. Création de petits jeux et d'outils simples.",
    journey2021:
      "Exploration du monde de la cybersécurité. Premières analyses de malware et tentatives d'exploitation.",
    journey2022: "Passage à Linux en os principal. Découverte de la puissance de l'open source.",
    journey2025:
      "Objectif : Continuer d'apprendre, et focus sur la creation de saas et la commercialisation de services + apprentissage quotidien et devenir rentable de mes bots crypto (proxmox, nouveau cloud services, web3, crypto, etc).",
    journeySummary:
      "Un parcours atypique, guidé par la passion et la curiosité. Toujours en train d'apprendre et de me réinventer.",
    skillsTitle: "Mes compétences",
    frontendNinja: "Ninja Frontend",
    backendSorcier: "Sorcier Backend",
    linuxAddict: "Addict Linux",
    frontendDesc: "Maîtrise des technologies frontend pour créer des interfaces utilisateur modernes et performantes.",
    backendDesc:
      "Expertise dans le développement backend pour créer des APIs robustes et des applications web scalables.",
    linuxDesc: "Passionné par Linux et l'open source. Maîtrise du terminal et des outils système.",
    advancedTitle: "Compétences Avancées",
    scrapingMaster: "Scraping Master",
    aiVocal: "IA Vocale",
    ecommerce: "E-commerce",
    automation: "Automation",
    apiDev: "API Dev",
    devops: "DevOps",
    projectWarning:
      "Ces techniques sont à utiliser avec précaution et uniquement dans un cadre légal. Je ne suis pas responsable de l'utilisation que vous en faites.",
    projectTitle: "Mes projets",
    projectSubtitle:
      "Un framework de scraping de données ultra-puissant, capable de contourner les protections les plus avancées.",
    projectTargets: "Cibles",
    projectAdvanced:
      "Un système avancé de rotation de proxies, de simulation humaine et d'exécution du moteur V8 pour contourner les protections JavaScript.",
    projectResult: "50 scrapers en parallèle, des millions de données extraites par jour.",
    projectTech: "Technologies",
    projectKing: "Roi du Scraping",
    projectFact: "Je suis un Data Scraping Master. Je peux extraire n'importe quelle donnée, de n'importe quel site.",
    contactTitle: "Contact",
    contactQuery: "Une question ? Un projet ? N'hésitez pas à me contacter.",
    contactStatus: "Toujours disponible pour de nouveaux défis.",
    contactInfo: "Réponse rapide et efficace garantie.",
    contactLevel: "Expert",
    contactTarget: "Devenir le meilleur Data Scientist de l'Extrême.",
    footerCopyright: "Tous droits réservés.",
    footerDisclaimer:
      "Ce site web est un portfolio personnel. Les opinions exprimées ici sont les miennes et ne représentent pas nécessairement celles de mes employeurs.",
  },
  en: {
    heroTitle: "Naïm.dev",
    heroStatus: "[DEVELOPER]",
    heroSubtitle: "Passionate about Linux, the Web and Cybersecurity. Always learning and creating new things.",
    heroTerminal1: "Unconditional Linux fan. Windows? Never heard of it.",
    heroTerminal2: "Full Stack Developer with a preference for the Backend.",
    heroTerminal3: "Cybersecurity Enthusiast. Security above all.",
    heroButton: "See my projects",
    aboutTitle: "About me",
    aboutCardTitle: "Linux Evangelist",
    aboutText:
      "Developer passionate about Linux, the Web and Cybersecurity. Always learning and creating new things. I am a big fan of Linux and I think it is the best operating system in the world. I am also a Full Stack developer with a preference for the Backend. I like to create robust and performant APIs and web applications. Finally, I am a Cybersecurity Enthusiast. Security is paramount to me and I always do my best to protect my systems and data.",
    aboutLearning: "I am currently learning Reverse Engineering and Malware Analysis.",
    aboutPivot: "Objective: Become an Extreme Data Scientist.",
    journeyTitle: "My journey",
    journey2018: "Discovery of code with HTML and CSS. First steps in the world of web development.",
    journey2020: "Python becomes my language of choice. Creation of small games and simple tools.",
    journey2021: "Exploration of the world of cybersecurity. First malware analysis and exploitation attempts.",
    journey2022: "Switch to Linux. Discovery of the power of the terminal and open source.",
    journey2025:
      "Objective: Become an Extreme Data Scientist. Data analysis, Machine Learning and Artificial Intelligence.",
    journeySummary: "An atypical journey, guided by passion and curiosity. Always learning and reinventing myself.",
    skillsTitle: "My skills",
    frontendNinja: "Frontend Ninja",
    backendSorcier: "Backend Sorcerer",
    linuxAddict: "Linux Addict",
    frontendDesc: "Mastery of frontend technologies to create modern and performant user interfaces.",
    backendDesc: "Expertise in backend development to create robust APIs and scalable web applications.",
    linuxDesc: "Passionate about Linux and open source. Mastery of the terminal and system tools.",
    advancedTitle: "Advanced Skills",
    scrapingMaster: "Scraping Master",
    aiVocal: "Vocal AI",
    ecommerce: "E-commerce",
    automation: "Automation",
    apiDev: "API Dev",
    devops: "DevOps",
    projectWarning:
      "These techniques are to be used with caution and only in a legal framework. I am not responsible for the use you make of them.",
    projectTitle: "My projects",
    projectSubtitle: "An ultra-powerful data scraping framework, capable of bypassing the most advanced protections.",
    projectTargets: "Targets",
    projectAdvanced:
      "An advanced system of proxy rotation, human simulation and execution of the V8 engine to bypass JavaScript protections.",
    projectResult: "50 scrapers in parallel, millions of data extracted per day.",
    projectTech: "Technologies",
    projectKing: "King of Scraping",
    projectFact: "I am a Data Scraping Master. I can extract any data, from any site.",
    contactTitle: "Contact",
    contactQuery: "A question? A project? Do not hesitate to contact me.",
    contactStatus: "Always available for new challenges.",
    contactInfo: "Fast and efficient response guaranteed.",
    contactLevel: "Expert",
    contactTarget: "Become the best Extreme Data Scientist.",
    footerCopyright: "All rights reserved.",
    footerDisclaimer:
      "This website is a personal portfolio. The opinions expressed here are my own and do not necessarily represent those of my employers.",
  },
  ar: {
    heroTitle: "Naïm.dev",
    heroStatus: "[مطور]",
    heroSubtitle: "شغوف بلينكس والويب والأمن السيبراني. أتعلم وأبتكر أشياء جديدة دائمًا.",
    heroTerminal1: "معجب غير مشروط بنظام لينكس. ويندوز؟ لا أعرفه.",
    heroTerminal2: "مطور Full Stack مع تفضيل للواجهة الخلفية.",
    heroTerminal3: "متحمس للأمن السيبراني. الأمن قبل كل شيء.",
    heroButton: "شاهد مشاريعي",
    aboutTitle: "عني",
    aboutCardTitle: "مبشر لينكس",
    aboutText:
      "مطور شغوف بلينكس والويب والأمن السيبراني. أتعلم وأبتكر أشياء جديدة دائمًا. أنا من أشد المعجبين بنظام لينكس وأعتقد أنه أفضل نظام تشغيل في العالم. أنا أيضًا مطور Full Stack مع تفضيل للواجهة الخلفية. أحب إنشاء واجهات برمجة تطبيقات وتطبيقات ويب قوية وعالية الأداء. أخيرًا ، أنا متحمس للأمن السيبراني. الأمن له أهمية قصوى بالنسبة لي وأبذل قصارى جهدي دائمًا لحماية أنظمتي وبياناتي.",
    aboutLearning: "أنا أتعلم حاليًا الهندسة العكسية وتحليل البرامج الضارة.",
    aboutPivot: "الهدف: أن أصبح عالم بيانات متطرف.",
    journeyTitle: "رحلتي",
    journey2018: "اكتشاف الكود باستخدام HTML و CSS. الخطوات الأولى في عالم تطوير الويب.",
    journey2020: "أصبحت Python لغتي المفضلة. إنشاء ألعاب صغيرة وأدوات بسيطة.",
    journey2021: "استكشاف عالم الأمن السيبراني. أول تحليل للبرامج الضارة ومحاولات الاستغلال.",
    journey2022: "التحول إلى لينكس. اكتشاف قوة المحطة الطرفية والمصدر المفتوح.",
    journey2025: "الهدف: أن أصبح عالم بيانات متطرف. تحليل البيانات والتعلم الآلي والذكاء الاصطناعي.",
    journeySummary: "رحلة غير نمطية ، تسترشد بالشغف والفضول. أتعلم وأعيد اختراع نفسي دائمًا.",
    skillsTitle: "مهاراتي",
    frontendNinja: "نينجا الواجهة الأمامية",
    backendSorcier: "ساحر الواجهة الخلفية",
    linuxAddict: "مدمن لينكس",
    frontendDesc: "إتقان تقنيات الواجهة الأمامية لإنشاء واجهات مستخدم حديثة وعالية الأداء.",
    backendDesc: "الخبرة في تطوير الواجهة الخلفية لإنشاء واجهات برمجة تطبيقات قوية وتطبيقات ويب قابلة للتطوير.",
    linuxDesc: "شغوف بلينكس والمصدر المفتوح. إتقان المحطة الطرفية وأدوات النظام.",
    advancedTitle: "مهارات متقدمة",
    scrapingMaster: "خبير الكشط",
    aiVocal: "الذكاء الاصطناعي الصوتي",
    ecommerce: "التجارة الإلكترونية",
    automation: "الأتمتة",
    apiDev: "تطوير API",
    devops: "ديف أوبس",
    projectWarning: "يجب استخدام هذه التقنيات بحذر وفقط في إطار قانوني. أنا لست مسؤولاً عن الاستخدام الذي تقوم به.",
    projectTitle: "مشاريعي",
    projectSubtitle: "إطار عمل قوي للغاية لكشط البيانات ، قادر على تجاوز الحماية الأكثر تقدمًا.",
    projectTargets: "الأهداف",
    projectAdvanced: "نظام متقدم لتدوير الوكيل ، والمحاكاة البشرية وتنفيذ محرك V8 لتجاوز حماية JavaScript.",
    projectResult: "50 مكشطة بالتوازي ، يتم استخراج ملايين البيانات يوميًا.",
    projectTech: "التقنيات",
    projectKing: "ملك الكشط",
    projectFact: "أنا خبير في كشط البيانات. يمكنني استخراج أي بيانات من أي موقع.",
    contactTitle: "اتصل",
    contactQuery: "سؤال؟ مشروع؟ لا تتردد في الاتصال بي.",
    contactStatus: "متاح دائمًا لتحديات جديدة.",
    contactInfo: "استجابة سريعة وفعالة مضمونة.",
    contactLevel: "خبير",
    contactTarget: "أن أصبح أفضل عالم بيانات متطرف.",
    footerCopyright: "جميع الحقوق محفوظة.",
    footerDisclaimer:
      "هذا الموقع هو محفظة شخصية. الآراء المعبر عنها هنا هي آراء شخصية ولا تمثل بالضرورة آراء أصحاب العمل.",
  },
  ru: {
    heroTitle: "Naïm.dev",
    heroStatus: "[РАЗРАБОТЧИК]",
    heroSubtitle: "Увлечен Linux, Web и кибербезопасностью. Всегда учусь и создаю что-то новое.",
    heroTerminal1: "Безусловный фанат Linux. Windows? Не знаю.",
    heroTerminal2: "Full Stack разработчик с предпочтением к Backend.",
    heroTerminal3: "Энтузиаст кибербезопасности. Безопасность превыше всего.",
    heroButton: "Посмотреть мои проекты",
    aboutTitle: "Обо мне",
    aboutCardTitle: "Евангелист Linux",
    aboutText:
      "Разработчик, увлеченный Linux, Web и кибербезопасностью. Всегда учусь и создаю что-то новое. Я большой поклонник Linux и считаю, что это лучшая операционная система в мире. Я также Full Stack разработчик с предпочтением к Backend. Мне нравится создавать надежные и производительные API и веб-приложения. Наконец, я энтузиаст кибербезопасности. Безопасность для меня превыше всего, и я всегда делаю все возможное, чтобы защитить свои системы и данные.",
    aboutLearning: "В настоящее время я изучаю реверс-инжиниринг и анализ вредоносного ПО.",
    aboutPivot: "Цель: Стать экстремальным специалистом по данным.",
    journeyTitle: "Мой путь",
    journey2018: "Открытие кода с помощью HTML и CSS. Первые шаги в мире веб-разработки.",
    journey2020: "Python становится моим языком выбора. Создание небольших игр и простых инструментов.",
    journey2021: "Исследование мира кибербезопасности. Первый анализ вредоносного ПО и попытки эксплуатации.",
    journey2022: "Переход на Linux. Открытие силы терминала и открытого исходного кода.",
    journey2025:
      "Цель: Стать экстремальным специалистом по данным. Анализ данных, машинное обучение и искусственный интеллект.",
    journeySummary: "Нетипичный путь, ведомый страстью и любопытством. Всегда учусь и переосмысливаю себя.",
    skillsTitle: "Мои навыки",
    frontendNinja: "Ниндзя Frontend",
    backendSorcier: "Волшебник Backend",
    linuxAddict: "Зависимый от Linux",
    frontendDesc:
      "Мастерство технологий Frontend для создания современных и производительных пользовательских интерфейсов.",
    backendDesc: "Экспертиза в разработке Backend для создания надежных API и масштабируемых веб-приложений.",
    linuxDesc: "Увлечен Linux и открытым исходным кодом. Мастерство терминала и системных инструментов.",
    advancedTitle: "Продвинутые навыки",
    scrapingMaster: "Мастер скрейпинга",
    aiVocal: "Голосовой ИИ",
    ecommerce: "Электронная коммерция",
    automation: "Автоматизация",
    apiDev: "API Dev",
    devops: "DevOps",
    projectWarning:
      "Эти методы следует использовать с осторожностью и только в рамках закона. Я не несу ответственности за то, как вы их используете.",
    projectTitle: "Мои проекты",
    projectSubtitle: "Сверхмощная платформа для сбора данных, способная обходить самую передовую защиту.",
    projectTargets: "Цели",
    projectAdvanced:
      "Продвинутая система ротации прокси, моделирования человека и выполнения движка V8 для обхода защиты JavaScript.",
    projectResult: "50 скреперов параллельно, миллионы данных извлекаются в день.",
    projectTech: "Технологии",
    projectKing: "Король скрейпинга",
    projectFact: "Я мастер сбора данных. Я могу извлечь любые данные с любого сайта.",
    contactTitle: "Контакт",
    contactQuery: "Вопрос? Проект? Не стесняйтесь обращаться ко мне.",
    contactStatus: "Всегда открыт для новых вызовов.",
    contactInfo: "Быстрый и эффективный ответ гарантирован.",
    contactLevel: "Эксперт",
    contactTarget: "Стать лучшим экстремальным специалистом по данным.",
    footerCopyright: "Все права защищены.",
    footerDisclaimer:
      "Этот веб-сайт является личным портфолио. Выраженные здесь мнения являются моими собственными и не обязательно отражают мнения моих работодателей.",
  },
  es: {
    heroTitle: "Naïm.dev",
    heroStatus: "[DESARROLLADOR]",
    heroSubtitle: "Apasionado por Linux, la Web y la Ciberseguridad. Siempre aprendiendo y creando cosas nuevas.",
    heroTerminal1: "Fan incondicional de Linux. ¿Windows? No lo conozco.",
    heroTerminal2: "Desarrollador Full Stack con preferencia por el Backend.",
    heroTerminal3: "Entusiasta de la Ciberseguridad. La seguridad ante todo.",
    heroButton: "Ver mis proyectos",
    aboutTitle: "Acerca de mí",
    aboutCardTitle: "Evangelista de Linux",
    aboutText:
      "Desarrollador apasionado por Linux, la Web y la Ciberseguridad. Siempre aprendiendo y creando cosas nuevas. Soy un gran fan de Linux y creo que es el mejor sistema operativo del mundo. También soy un desarrollador Full Stack con preferencia por el Backend. Me gusta crear APIs y aplicaciones web robustas y de alto rendimiento. Finalmente, soy un entusiasta de la Ciberseguridad. La seguridad es primordial para mí y siempre hago todo lo posible para proteger mis sistemas y datos.",
    aboutLearning: "Actualmente estoy aprendiendo Ingeniería Inversa y Análisis de Malware.",
    aboutPivot: "Objetivo: Convertirme en un Científico de Datos Extremo.",
    journeyTitle: "Mi trayectoria",
    journey2018: "Descubrimiento del código con HTML y CSS. Primeros pasos en el mundo del desarrollo web.",
    journey2020: "Python se convierte en mi lenguaje preferido. Creación de pequeños juegos y herramientas sencillas.",
    journey2021: "Exploración del mundo de la ciberseguridad. Primeros análisis de malware e intentos de explotación.",
    journey2022: "Transición a Linux. Descubrimiento del poder de la terminal y el código abierto.",
    journey2025:
      "Objetivo: Convertirme en un Científico de Datos Extremo. Análisis de datos, Machine Learning e Inteligencia Artificial.",
    journeySummary:
      "Una trayectoria atípica, guiada por la pasión y la curiosidad. Siempre aprendiendo y reinventándome.",
    skillsTitle: "Mis habilidades",
    frontendNinja: "Ninja Frontend",
    backendSorcier: "Hechicero Backend",
    linuxAddict: "Adicto a Linux",
    frontendDesc:
      "Dominio de las tecnologías frontend para crear interfaces de usuario modernas y de alto rendimiento.",
    backendDesc: "Experiencia en el desarrollo backend para crear APIs robustas y aplicaciones web escalables.",
    linuxDesc: "Apasionado por Linux y el código abierto. Dominio de la terminal y las herramientas del sistema.",
    advancedTitle: "Habilidades Avanzadas",
    scrapingMaster: "Maestro del Scraping",
    aiVocal: "IA Vocal",
    ecommerce: "Comercio Electrónico",
    automation: "Automatización",
    apiDev: "API Dev",
    devops: "DevOps",
    projectWarning:
      "Estas técnicas deben utilizarse con precaución y solo en un marco legal. No soy responsable del uso que hagas de ellas.",
    projectTitle: "Mis proyectos",
    projectSubtitle:
      "Un framework de scraping de datos ultra potente, capaz de sortear las protecciones más avanzadas.",
    projectTargets: "Objetivos",
    projectAdvanced:
      "Un sistema avanzado de rotación de proxies, simulación humana y ejecución del motor V8 para sortear las protecciones de JavaScript.",
    projectResult: "50 scrapers en paralelo, millones de datos extraídos por día.",
    projectTech: "Tecnologías",
    projectKing: "Rey del Scraping",
    projectFact: "Soy un maestro del scraping de datos. Puedo extraer cualquier dato de cualquier sitio.",
    contactTitle: "Contacto",
    contactQuery: "¿Una pregunta? ¿Un proyecto? No dudes en contactarme.",
    contactStatus: "Siempre disponible para nuevos desafíos.",
    contactInfo: "Respuesta rápida y eficiente garantizada.",
    contactLevel: "Experto",
    contactTarget: "Convertirme en el mejor Científico de Datos Extremo.",
    footerCopyright: "Todos los derechos reservados.",
    footerDisclaimer:
      "Este sitio web es un portafolio personal. Las opiniones expresadas aquí son mías y no representan necesariamente las de mis empleadores.",
  },
}

export function useTranslation() {
  const [language, setLanguage] = useState<Language>("fr")
  const [mounted, setMounted] = useState(false)

  useEffect(() => {
    setMounted(true)
    const savedLanguage = localStorage.getItem("portfolio-language") as Language
    if (savedLanguage && translations[savedLanguage]) {
      setLanguage(savedLanguage)
    }
  }, [])

  const changeLanguage = (newLanguage: Language) => {
    setLanguage(newLanguage)
    if (mounted) {
      localStorage.setItem("portfolio-language", newLanguage)
    }
  }

  const t = (key: keyof typeof translations.fr): string => {
    if (!mounted) return translations.fr[key] // Fallback pendant l'hydratation
    return translations[language][key] || translations.fr[key]
  }

  return { language, changeLanguage, t, mounted }
}
